/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components.configuration.configurators;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.beans.PropertyDescriptor;
import java.util.LinkedList;
import java.util.TreeSet;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.sdedit.ui.components.configuration.Bean;
import net.sf.sdedit.ui.components.configuration.Configurator;
import net.sf.sdedit.ui.components.configuration.DataObject;
import net.sf.sdedit.ui.components.configuration.configurators.StringSelectionReceiver;
import net.sf.sdedit.util.ListModelAdapter;
import net.sf.sdedit.util.Utilities;

public class StringSetConfigurator<C extends DataObject>
extends Configurator<String[], C>
implements StringSelectionReceiver,
ListSelectionListener {
    private static final long serialVersionUID = 6259747723598495800L;
    private JList list;
    private ListModelAdapter lma;
    private JLabel descriptionLabel;
    protected String[] fileTypes;
    private boolean refresh;

    public StringSetConfigurator(Bean<C> bean, PropertyDescriptor property) {
        super(bean, property);
        this.setLayout(new BorderLayout());
        this.lma = new ListModelAdapter();
        this.list = new JList(this.lma);
        this.list.addListSelectionListener(this);
        JScrollPane scrollPane = new JScrollPane(this.list);
        this.add((Component)scrollPane, "Center");
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        this.add((Component)topPanel, "North");
        this.descriptionLabel = new JLabel(this.getAdjustable().info());
        topPanel.add((Component)this.descriptionLabel, "Center");
        this.setPreferredSize(new Dimension(400, 250));
        this.initialize(true);
        this.refresh = false;
    }

    @Override
    protected void _actionPerformed(ActionEvent evt) {
        int[] indices = this.list.getSelectedIndices();
        String[] strings = Utilities.castArray(this.lma.getData(), String.class);
        LinkedList<String> selectedStrings = new LinkedList<String>();
        for (int i = 0; i < indices.length; ++i) {
            selectedStrings.add(strings[indices[i]]);
        }
        this.getBean().setValue(this.getProperty(), selectedStrings.toArray(new String[0]));
    }

    @Override
    protected void _setEnabled(boolean enabled) {
        this.list.setEnabled(enabled);
    }

    @Override
    public void focus() {
    }

    @Override
    protected synchronized void refresh(String[] value) {
        String[] data;
        this.refresh = true;
        TreeSet<String> union = new TreeSet<String>();
        for (String d : data = Utilities.castArray(this.lma.getData(), String.class)) {
            union.add(d);
        }
        for (String v : value) {
            union.add(v);
        }
        String[] allStrings = union.toArray(new String[0]);
        LinkedList<Integer> selectedIndicesList = new LinkedList<Integer>();
        for (int i = 0; i < value.length; ++i) {
            int index = Utilities.indexOf(allStrings, value[i]);
            if (index < 0) continue;
            selectedIndicesList.add(index);
        }
        int[] selectedIndices = new int[selectedIndicesList.size()];
        int i = 0;
        for (Integer index : selectedIndicesList) {
            selectedIndices[i] = index;
            ++i;
        }
        this.list.setSelectedIndices(selectedIndices);
        this.refresh = false;
    }

    @Override
    public void reinitialize() {
        this.initialize(false);
    }

    private void initialize(boolean init) {
        TreeSet<String> choices = new TreeSet<String>(this.getBean().getStringsForProperty(this.getProperty()));
        TreeSet<String> values = new TreeSet<String>();
        for (String s : (String[])this.getValue()) {
            if (!choices.contains(s)) continue;
            values.add(s);
        }
        this.lma.setData(choices);
        this.refresh(values.toArray(new String[0]));
    }

    @Override
    public synchronized void valueChanged(ListSelectionEvent e) {
        if (!this.refresh) {
            this.actionPerformed(null);
        }
    }
}

