/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.execution.scope.internal;

import com.google.inject.Key;
import com.google.inject.OutOfScopeException;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.util.Providers;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.maven.execution.MojoExecutionEvent;
import org.apache.maven.execution.MojoExecutionListener;
import org.apache.maven.execution.scope.WeakMojoExecutionListener;
import org.apache.maven.plugin.MojoExecutionException;

public class MojoExecutionScope
implements Scope,
MojoExecutionListener {
    private static final Provider<Object> SEEDED_KEY_PROVIDER = new Provider<Object>(){

        public Object get() {
            throw new IllegalStateException();
        }
    };
    private final ThreadLocal<LinkedList<ScopeState>> values = new ThreadLocal();

    public void enter() {
        LinkedList<ScopeState> stack = this.values.get();
        if (stack == null) {
            stack = new LinkedList();
            this.values.set(stack);
        }
        stack.addFirst(new ScopeState());
    }

    private ScopeState getScopeState() {
        LinkedList<ScopeState> stack = this.values.get();
        if (stack == null || stack.isEmpty()) {
            throw new IllegalStateException();
        }
        return stack.getFirst();
    }

    public void exit() throws MojoExecutionException {
        LinkedList<ScopeState> stack = this.values.get();
        if (stack == null || stack.isEmpty()) {
            throw new IllegalStateException();
        }
        stack.removeFirst();
        if (stack.isEmpty()) {
            this.values.remove();
        }
    }

    public <T> void seed(Class<T> clazz, Provider<T> value) {
        this.getScopeState().seeded.put(Key.get(clazz), value);
    }

    public <T> void seed(Class<T> clazz, T value) {
        this.getScopeState().seeded.put(Key.get(clazz), Providers.of(value));
    }

    public <T> Provider<T> scope(final Key<T> key, final Provider<T> unscoped) {
        return new Provider<T>(){

            public T get() {
                LinkedList stack = (LinkedList)MojoExecutionScope.this.values.get();
                if (stack == null || stack.isEmpty()) {
                    throw new OutOfScopeException("Cannot access " + key + " outside of a scoping block");
                }
                ScopeState state = (ScopeState)stack.getFirst();
                Provider seeded = (Provider)state.seeded.get(key);
                if (seeded != null) {
                    return seeded.get();
                }
                Object provided = state.provided.get(key);
                if (provided == null && unscoped != null) {
                    provided = unscoped.get();
                    state.provided.put(key, provided);
                }
                return provided;
            }
        };
    }

    public static <T> Provider<T> seededKeyProvider() {
        return SEEDED_KEY_PROVIDER;
    }

    @Override
    public void beforeMojoExecution(MojoExecutionEvent event) throws MojoExecutionException {
        for (WeakMojoExecutionListener provided : this.getProvidedListeners()) {
            provided.beforeMojoExecution(event);
        }
    }

    @Override
    public void afterMojoExecutionSuccess(MojoExecutionEvent event) throws MojoExecutionException {
        for (WeakMojoExecutionListener provided : this.getProvidedListeners()) {
            provided.afterMojoExecutionSuccess(event);
        }
    }

    @Override
    public void afterExecutionFailure(MojoExecutionEvent event) {
        for (WeakMojoExecutionListener provided : this.getProvidedListeners()) {
            provided.afterExecutionFailure(event);
        }
    }

    private Collection<WeakMojoExecutionListener> getProvidedListeners() {
        IdentityHashMap listeners = new IdentityHashMap();
        for (Object provided : this.getScopeState().provided.values()) {
            if (!(provided instanceof WeakMojoExecutionListener)) continue;
            listeners.put((WeakMojoExecutionListener)provided, null);
        }
        return listeners.keySet();
    }

    private static final class ScopeState {
        private final Map<Key<?>, Provider<?>> seeded = new HashMap();
        private final Map<Key<?>, Object> provided = new HashMap();

        private ScopeState() {
        }
    }
}

